﻿/*
Run this script on:

        4_2_0_Core    -  This database will be modified

to upgrade it to:

        5_0_0_Core

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
PRINT N'Altering [hips].[SinglePatientInHospitalGet]'
GO
-- =============================================
-- Create date:   17 April 2014
-- Description:   Gets a single patient and their details 
-- =============================================
ALTER PROCEDURE [hips].[SinglePatientInHospitalGet] 
 (
      @HospitalCodeSystem VARCHAR(20),
      @PatientId INT,
      @HealthProviderOrganisationNetworkId INT      
  )
AS 
    BEGIN
		
        SELECT  e.EpisodeId ,
				hp.Mrn ,
				pm.CurrentSexId,
				pm.DateOfBirth,
				pm.MedicareNumber,
				pm.MedicareIrn,
				pm.DvaNumber,
				pmn.FamilyName,
				pmn.GivenNames,
				pmnt.Description AS Title,
				pmns.Description AS Suffix,
				pmi.Ihi,
				pmi.IhiStatusId,
				pmi.IhiRecordStatusId,
				pmi.DateLastValidated AS IhiLastValidated,
				pmi.RegisteredSexId,
				pmi.RegisteredFamilyName,
				pmi.RegisteredGivenName,
				hc.Code as HospitalCode,
				h.HospitalId,
				h.Name as HospitalName,
				hpop.PcehrAdvertised,
				hpop.PcehrDisclosed,
				e.Ward,
				e.Room,
				e.Bed,
                e.AdmissionDate ,
                e.AdmissionReason , 
                e.DischargeDate ,
                rp.FamilyName AS ResponsibleProviderFamilyName ,
                rp.GivenNames AS ResponsibleProviderGivenNames ,
                rpt.Description AS ResponsibleProviderTitle ,
                rps.Description AS ResponsibleProviderSuffix ,
                e.SourceSystemEpisodeId ,
                e.ConsentWithdrawn,
				(SELECT COUNT(ee.EpisodeId)
					FROM hips.Episode ee
					WHERE ee.PatientId = hp.PatientId) AS EpisodeCount,				
                (SELECT TOP 1 da.AuditInformation 
						FROM hips.DisclosureAudit da 
						WHERE hp.PatientMasterId = da.PatientMasterId 
						AND h.HealthProviderOrganisationId = da.HealthProviderOrganisationId
						ORDER BY DisclosureAuditId DESC) AS DisclosureAuditInformation
        FROM    hips.HospitalPatient hp
               LEFT OUTER JOIN hips.Episode e ON hp.PatientId = e.PatientId
                INNER JOIN
				(	-- The latest admission date/time for the patient master at the hospital
					SELECT  PatientMasterId, HospitalId, MAX(AdmissionDate) AdmissionDate
					FROM    hips.HospitalPatient hp
					LEFT OUTER JOIN hips.Episode e ON hp.PatientId = e.PatientId
					WHERE  hp.PatientId = @PatientId
					GROUP BY PatientMasterId, HospitalId
				) AS LatestAdmission
						ON hp.PatientMasterId = LatestAdmission.PatientMasterId
						AND (LatestAdmission.AdmissionDate is null OR e.AdmissionDate = LatestAdmission.AdmissionDate)
                INNER JOIN hips.HospitalCode hc	ON hp.HospitalId = hc.HospitalId	
					AND hc.CodeSystemId = (SELECT CodeSystemId FROM hips.CodeSystem WHERE Code = @HospitalCodeSystem)
				INNER JOIN hips.Hospital h ON hp.HospitalId = h.HospitalId
				INNER JOIN hips.HealthProviderOrganisation AS hpo WITH (NOLOCK) ON h.HealthProviderOrganisationId = hpo.HealthProviderOrganisationId				
                LEFT OUTER JOIN hips.HealthProviderIndividual rp ON e.ResponsibleProviderId = rp.HealthProviderIndividualId
                LEFT OUTER JOIN hips.Title rpt ON rp.TitleId = rpt.TitleId
                LEFT OUTER JOIN hips.Suffix rps ON rp.SuffixId = rps.SuffixId
                INNER JOIN hips.PatientMaster pm ON hp.PatientMasterId = pm.PatientMasterId
				INNER JOIN hips.PatientMasterName pmn ON pm.PatientMasterId = pmn.PatientMasterId AND pmn.NameTypeId = 2 -- Current Name
				LEFT JOIN hips.PatientMasterIhi pmi ON pm.PatientMasterId = pmi.PatientMasterId AND pmi.HealthProviderOrganisationNetworkId = @HealthProviderOrganisationNetworkId
                LEFT JOIN hips.Title pmnt ON pmn.TitleId = pmnt.TitleId
				LEFT JOIN hips.Suffix pmns ON pmn.SuffixId = pmns.SuffixId
				LEFT JOIN hips.HealthProviderOrganisationPatient hpop
					ON h.HealthProviderOrganisationId = hpop.HealthProviderOrganisationId
					AND hp.PatientMasterId = hpop.PatientMasterId
        WHERE   hp.PatientId = @PatientId

END
GO
